CREATE PROCEDURE dbo.CPUJ_Cbtes_Lotes_Importar @pJson VARCHAR(8000)
AS 
SET NOCOUNT ON 

/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pFlagUsarTrans			TINYINT
DECLARE @pModoDebug				TINYINT
DECLARE @pLinea					VARCHAR(8000)
DECLARE @pLote					VARCHAR(20)
DECLARE @pTipo					CHAR(3)
DECLARE @pPreProceso			TINYINT
DECLARE @pNroLineaArchivo		INT
DECLARE @pId_Usuario			SMALLINT
DECLARE @pFecha_Lote			DATETIME

SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pLinea						= ISNULL(CONVERT(VARCHAR(8000), dbo.CF_JSON_VALUE(@pJson,'Linea')), '')
SET @pLote						= ISNULL(CONVERT(VARCHAR(20), dbo.CF_JSON_VALUE(@pJson,'Lote')),'')
SET @pTipo						= ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Tipo')),'')
SET @pPreProceso				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'PreProceso')), 0)
SET @pNroLineaArchivo			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'NroLineaArchivo')), 0)
SET @pId_Usuario				= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Usuario')), 0)
SET @pFecha_Lote				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Lote')), '19000101')
/*FIN Variables recibidas por parametro a traves del JSON*/

/*Declaracion Variables Locales*/
DECLARE @json							VARCHAR(8000)
DECLARE @Result_Stored_Invocado			INT
DECLARE @rta_JSON_Stored_Invocado		VARCHAR(8000)
DECLARE @Result_Tabla_Stored_Invocado	TABLE	(ErrorNumber	INT,
												ErrorSeverity	INT,
												ErrorState		INT,
												ErrorProcedure  VARCHAR(1000),
												ErrorLine		INT,
												ErrorMessage	VARCHAR(4000))
/*FIN Declaracion Variables Locales*/

BEGIN TRY

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPUJ_Cbtes_Lotes_Importar'
		PRINT 'Parametros:'
		PRINT '@pLote: ' + LTRIM(RTRIM(@pLote))
		PRINT '@pLinea: ' + LTRIM(RTRIM(@pLinea))
		PRINT '@pTipo: ' + LTRIM(RTRIM(@pTipo))
		PRINT '@pPreProceso: ' + CONVERT(VARCHAR(10), @pPreProceso)
		PRINT '@pNroLineaArchivo: ' + CONVERT(VARCHAR(10), @pNroLineaArchivo)
		PRINT '@pId_Usuario: ' + CONVERT(VARCHAR(10), @pId_Usuario)
	END
	
	/*====================================================================================================================================================*/
	
	--NOTA: SE DEBE IMPLEMENTAR PARA CADA CLIENTE

	/*====================================================================================================================================================*/

	IF(@pTipo = 'OTR')
	BEGIN
		IF(@pModoDebug = 1)
		BEGIN
			PRINT 'Tipo Lote Cbte: OTRo'
		END

		/*Por error de validacion debe retornar:*/
		/*
		RAISERROR (@Error_A_Retornar, 16, 1)

		RETURN 1111	
		*/
		/*====================================================================================================================================================*/
		
		/*Por Exito debe retornar:*/
		/*
		SELECT	 0				AS ErrorNumber 
				,0				AS ErrorSeverity  
				,0				AS ErrorState 
				,0				AS ErrorProcedure  
				,0				AS ErrorLine		
				,''				AS ErrorMessage
		*/
		/*====================================================================================================================================================*/
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT 'FIN Stored Procedure: CPUJ_Cbtes_Lotes_Importar'
	END

	/*====================================================================================================================================================*/

END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	RETURN 9999
END CATCH

RETURN 0 

/*
DECLARE @pJson VARCHAR(8000)

SET @pJson = '{' +
			 '"FlagUsarTrans":"0",'+
			 '"ModoDebug":"1",'+
			 '"Linea":"Cuota socio;10/05/2021 15:06:04;01/01/2018 00:00:00;;11;ACTIVO F;<Ninguno>;11829;;Barboza Gabriela Nora;8085;331.123.222;Efectivo;Cobro;<Ninguna>;;;;;;0;0;0;0;LUCIANA PODESTA;CAJA7;LANUS",'+
			 '"Lote":"ztest1",'+
			 '"Tipo":"OTR",'+
			 '"PreProceso":"1",'+
			 '"NroLineaArchivo":"1",'+
			 '"Id_Usuario":"-1"'+
			 '}'

EXEC CPUJ_Cbtes_Lotes_Importar @pJson
GO
*/